<?php
include_once '../inc/start.php';
if(empty($_POST['phpaction'])) {
	log_error("Прямой вызов actions_gift.php");
	exit('Ошибка: [Прямой вызов инклуда]');
}
if(!is_admin()) {
	exit('Ошибка: [Доступно только администраторам]');
}
$token = clean($_POST['token'], null);
if($conf->token == 1 && ($_SESSION['token'] != $token)) {
	log_error("Неверный токен");
	exit('Ошибка: [Неверный токен]');
}

/* Услуги
=========================================*/
if(isset($_POST['get_services'])) {
	$id = checkJs($_POST['id'], "int");
	if(empty($id)) {
		exit ();
	}

	$i   = 0;
	$STH = $pdo->query("SELECT id,name FROM gifts WHERE server = '$id' ORDER BY trim");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	while($row = $STH->fetch()) {
		$i++;
		echo '<option value="'.$row->id.'">'.$row->name.'</option>';
	}

	if($i == 0) {
		echo '<option value="0">Услуг нет</option>';
	}

	exit();
}

if(isset($_POST['get_services2'])) {
	$id = checkJs($_POST['id'], "int");
	if(empty($id)) {
		exit ();
	}
	?>
	<div class="block">
		<?php
		$STH = $pdo->query("SELECT * FROM gifts WHERE server = '$id' ORDER BY trim");
		$STH->execute();
		$gifts = $STH->fetchAll();
		$count2   = count($gifts);
		
		for($i2 = 0; $i2 < $count2; $i2++) {
			$idd = $gifts[$i2]['id'];
			?>
			<div class="row mb-10" id="service<?php echo $idd ?>">
				<div class="col-md-6">
					<div class="block_head">Услуга #<?php echo $i2 + 1; ?></div>
					<select class="form-control mt-10" id="sale<?php echo $idd ?>">
						<option value="1" <?php if($gifts[$i2]['sale'] == '1') {
							echo 'selected';
						} ?>>Продажа: включена
						</option>
						<option value="2" <?php if($gifts[$i2]['sale'] == '2') {
							echo 'selected';
						} ?>>Продажа: выключена
						</option>
					</select>
					<select class="form-control mt-10" id="show<?php echo $idd ?>">
						<option value="1" <?php if($gifts[$i2]['show_adm'] == '1') {
							echo 'selected';
						} ?>>Отображение на странице администраторов: Включено
						</option>
						<option value="2" <?php if($gifts[$i2]['show_adm'] == '2') {
							echo 'selected';
						} ?>>Отображение на странице администраторов: Выключено
						</option>
					</select>
					<input value="<?php echo $gifts[$i2]['name'] ?>" class="form-control mt-10" type="text" maxlength="255" id="name<?php echo $idd ?>" placeholder="Название услуги" autocomplete="off">
					<input value="<?php echo $gifts[$i2]['rights'] ?>" class="form-control mt-10" type="text" maxlength="25" id="flags<?php echo $idd ?>" placeholder="Обработчик" autocomplete="off">
					<input value="<?php echo $gifts[$i2]['stime'] ?>" class="form-control mt-10" type="text" maxlength="25" id="stime<?php echo $idd ?>" placeholder="Измерение" autocomplete="off">
					<input value="<?php echo $gifts[$i2]['discount'] ?>" class="form-control mt-10" type="number" maxlength="2" id="discount<?php echo $idd ?>" placeholder="Скидка в %" autocomplete="off">
					<div class="form-group">
						<small>db хост</small><input value="<?php echo $gifts[$i2]['dbhost'] ?>" type="text" class="form-control" id="db_ihost<?php echo $idd ?>" maxlength="64" placeholder="localhost" autocomplete="off">
						<small>db логин</small><input value="<?php echo $gifts[$i2]['dbuser'] ?>" type="text" class="form-control" id="db_ilogin<?php echo $idd ?>" maxlength="64" placeholder="dbuser" autocomplete="off">
						<small>db пароль</small><input value="<?php echo $gifts[$i2]['dbpass'] ?>" type="password" class="form-control" id="db_ipass<?php echo $idd ?>" maxlength="64" placeholder="password" autocomplete="off">
						<small>db база</small><input value="<?php echo $gifts[$i2]['dbname'] ?>" type="text" class="form-control" id="db_iname<?php echo $idd ?>" maxlength="64" placeholder="dbname" autocomplete="off">
					</div>
					<br>
					<textarea id="text<?php echo $idd ?>" class="form-control" rows="5"><?php echo $gifts[$i2]['text'] ?></textarea>
					<script>
						$(document).ready(function () {
							init_tinymce('text<?php echo $idd ?>', '<?php echo md5($conf->code); ?>', 'lite');
						});
					</script>
					<button class="btn btn-default mt-10" onclick="edit_service_gift(<?php echo $idd ?>);">Изменить</button>
					<button class="btn btn-default mt-10" onclick="dell_service_gift(<?php echo $idd ?>);">Удалить</button>
					<button class="btn btn-default mt-10" onclick="up_service_gift(<?php echo $idd ?>);">Поднять</button>
					<button class="btn btn-default mt-10" onclick="down_service_gift(<?php echo $idd ?>);">Опустить</button>
				</div>
				<div class="col-md-6">
					<div class="block_head">Тарифы услуги #<?php echo $i2 + 1; ?></div>
					<div class="tarifs">
						<table class="table table-bordered table-condensed mb-0">
							<thead>
							<tr>
								<td>#</td>
								<td>Количество</td>
								<td>Цена</td>
								<td>Скидка</td>
								<td>Действие</td>
							</tr>
							</thead>
							<tbody>
							<?php
							$id2 = $idd;
							$STH = $pdo->query("SELECT * FROM gifts__tarifs WHERE service = '$id2'");
							$STH->execute();
							$tarifs = $STH->fetchAll();
							$count3 = count($tarifs);
							for($i3 = 0; $i3 < $count3; $i3++) {
								if($tarifs[$i3]['time'] == 0) {
									$tarifs[$i3]['time'] = 'Навсегда';
								}
								?>
								<tr id="tarif<?php echo $tarifs[$i3]['id'] ?>">
									<td width="1%"><?php echo $i3 + 1; ?></td>
									<td>
										<input value="<?php echo $tarifs[$i3]['time'] ?>" class="form-control" type="text" maxlength="6" id="time<?php echo $tarifs[$i3]['id'] ?>" placeholder="Время" autocomplete="off">
									</td>
									<td>
										<input value="<?php echo $tarifs[$i3]['pirce'] ?>" class="form-control" type="text" maxlength="6" id="pirce<?php echo $tarifs[$i3]['id'] ?>" placeholder="Цена" autocomplete="off">
									</td>
									<td>
										<input value="<?php echo $tarifs[$i3]['discount'] ?>" class="form-control" type="text" maxlength="6" id="tarif_discount<?php echo $tarifs[$i3]['id'] ?>" placeholder="Скидка" autocomplete="off">
									</td>
									<td width="20%">
										<div class="btn-group" role="group">
											<button onclick="edit_tarif_gift (<?php echo $tarifs[$i3]['id'] ?>);" class="btn btn-default" type="button">
												<span class="glyphicon glyphicon-pencil"></span></button>
											<button onclick="dell_tarif_gift (<?php echo $tarifs[$i3]['id'] ?>);" class="btn btn-default" type="button">
												<span class="glyphicon glyphicon-trash"></span></button>
										</div>
									</td>
								</tr>
								<?php
							}
							?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	exit();
}
if(isset($_POST['add_tarif'])) {
	$service = check($_POST['service'], "int");
	$type    = 0;
	if(($_POST['time'] == 0) or (strnatcasecmp($_POST['time'], 'навсегда') == 0)) {
		$time = 0;
	} else {
		if(strpos($_POST['time'], '-') == false) {
			$type = 0;
			$time = check($_POST['time'], "int");
		} else {
			$time    = explode("-", $_POST['time']);
			$time[0] = check($time[0], "int");
			$time[1] = check($time[1], "int");
			$type    = 1;
		}
	}
	$pirce    = check($_POST['pirce'], "float");
	$discount = check($_POST['discount'], "int");

	if(empty($discount)) {
		$discount = 0;
	}

	if(empty($service)) {
		exit (json_encode(array('status' => '2', 'input' => 'gifts', 'reply' => 'Заполните!')));
	}
	if(empty($pirce)) {
		exit (json_encode(array('status' => '2', 'input' => 'pirce', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($pirce, 'UTF-8') > 6) {
		exit (json_encode(array('status' => '2', 'input' => 'pirce', 'reply' => 'Не более 6 символов!')));
	}

	$STH = $pdo->query("SELECT id FROM gifts WHERE id='$service' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$row = $STH->fetch();
	if(empty($row->id)) {
		exit(json_encode(array('status' => '2')));
	}

	if($type == 0) {
		if(empty($time) and $time != 0) {
			exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Заполните!')));
		}
		if(mb_strlen($time, 'UTF-8') > 6) {
			exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Не более 6 символов!')));
		}

		$STH = $pdo->prepare("INSERT INTO gifts__tarifs (service,pirce,time,discount) VALUES (:service, :pirce, :time, :discount)");
		if($STH->execute(array('service' => $service, 'pirce' => $pirce, 'time' => $time, 'discount' => $discount)) == '1') {
			exit(json_encode(array('status' => '1')));
		}
	} elseif($type == 1) {
		if((empty($time[0]) and $time[0] != 0) or (empty($time[1]) and $time[1] != 0) or ($time[0] == $time[1]) or ($time[0] > $time[1])) {
			exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Укажите корректный диапазон!')));
		}
		if(mb_strlen($time[0], 'UTF-8') > 3 or mb_strlen($time[1], 'UTF-8') > 3) {
			exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Не более 3 символов на каждый конец диапазона!')));
		}

		for($i = $time[0]; $i <= $time[1]; $i++) {
			$pirce2 = $pirce * $i;
			$STH    = $pdo->prepare("INSERT INTO gifts__tarifs (service,pirce,time,discount) values (:service, :pirce, :time, :discount)");
			$STH->execute(array('service' => $service, 'pirce' => $pirce2, 'time' => $i, 'discount' => $discount));
		}
		exit(json_encode(array('status' => '1')));
	}
}
if(isset($_POST['edit_tarif'])) {
	$id = check($_POST['id'], "int");
	if(($_POST['time'] == 0) or (strnatcasecmp($_POST['time'], 'навсегда') == 0)) {
		$time = 0;
	} else {
		$time = check($_POST['time'], "int");
	}
	$pirce    = check($_POST['pirce'], "float");
	$discount = check($_POST['discount'], "int");

	if(empty($discount)) {
		$discount = 0;
	}

	if(empty($id)) {
		exit(json_encode(array('status' => '2')));
	}
	if(empty($time) and $time != 0) {
		exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Заполните!')));
	}
	if(empty($pirce)) {
		exit (json_encode(array('status' => '2', 'input' => 'pirce', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($time, 'UTF-8') > 6) {
		exit (json_encode(array('status' => '2', 'input' => 'time', 'reply' => 'Не более 6 символов!')));
	}
	if(mb_strlen($pirce, 'UTF-8') > 6) {
		exit (json_encode(array('status' => '2', 'input' => 'pirce', 'reply' => 'Не более 6 символов!')));
	}

	$STH = $pdo->prepare("UPDATE gifts__tarifs SET time=:time,pirce=:pirce,discount=:discount WHERE id='$id' LIMIT 1");
	if($STH->execute(array('time' => $time, 'pirce' => $pirce, 'discount' => $discount)) == '1') {
		exit(json_encode(array('status' => '1')));
	}
}
if(isset($_POST['dell_tarif'])) {
	$id = checkJs($_POST['id'], "int");
	if(empty($id)) {
		exit (json_encode(array('status' => '2')));
	}
	$pdo->exec("DELETE FROM gifts__tarifs WHERE id='$id'");
	exit(json_encode(array('status' => '1')));
}
if(isset($_POST['up_service'])) {
	$number = check($_POST['id'], "int");

	$STH = $pdo->query("SELECT server FROM gifts WHERE id='$number' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$row    = $STH->fetch();
	$server = $row->server;

	if(empty($number) or empty($server)) {
		exit(json_encode(array('status' => '2')));
	}

	$STH = $pdo->query("SELECT id,trim FROM gifts WHERE id='$number' and server='$server' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$tmp = $STH->fetch();
	if(empty($tmp->id)) {
		exit(json_encode(array('status' => '2')));
	}
	if($tmp->trim == 1) {
		exit(json_encode(array('status' => '2')));
	}
	$poz  = $tmp->trim;
	$poz2 = $tmp->trim - 1;

	$STH = $pdo->prepare("UPDATE gifts SET trim=:trim WHERE trim='$poz2' and server='$server' LIMIT 1");
	if($STH->execute(array('trim' => $poz)) == '1') {
		$STH = $pdo->prepare("UPDATE gifts SET trim=:poz2 WHERE id='$number' and server='$server' LIMIT 1");
		if($STH->execute(array('poz2' => $poz2)) == '1') {
			exit(json_encode(array('status' => '1')));
		} else {
			exit(json_encode(array('status' => '2')));
		}
	} else {
		exit(json_encode(array('status' => '2')));
	}
}
if(isset($_POST['down_service'])) {
	$number = check($_POST['id'], "int");

	$STH = $pdo->query("SELECT server FROM gifts WHERE id='$number' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$row    = $STH->fetch();
	$server = $row->server;

	if(empty($number) or empty($server)) {
		exit(json_encode(array('status' => '2')));
	}

	$STH = $pdo->query("SELECT id,trim from gifts WHERE id='$number' and server='$server' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$tmp = $STH->fetch();
	if(empty($tmp->id)) {
		exit(json_encode(array('status' => '2')));
	}
	$poz  = $tmp->trim;
	$poz2 = $tmp->trim + 1;
	$STH  = $pdo->query("SELECT trim from gifts WHERE server='$server' ORDER BY trim DESC LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$tmp = $STH->fetch();
	$max = $tmp->trim;

	if($poz == $max) {
		exit(json_encode(array('status' => '2')));
	}

	$STH = $pdo->prepare("UPDATE gifts SET trim=:trim WHERE trim='$poz2' and server='$server' LIMIT 1");
	if($STH->execute(array('trim' => $poz)) == '1') {
		$STH = $pdo->prepare("UPDATE gifts SET trim=:trim WHERE id='$number' and server='$server' LIMIT 1");
		if($STH->execute(array('trim' => $poz2)) == '1') {
			exit(json_encode(array('status' => '1')));
		} else {
			exit(json_encode(array('status' => '2')));
		}
	} else {
		exit(json_encode(array('status' => '2')));
	}
}
if(isset($_POST['dell_service'])) {
	$main_id = checkJs($_POST['id'], "int");
	if(empty($main_id)) {
		exit (json_encode(array('status' => '2')));
	}

	$STH = $pdo->query("SELECT server FROM gifts WHERE id='$main_id' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$row    = $STH->fetch();
	$server = $row->server;

	$STH = $pdo->query("SELECT trim from gifts WHERE id='$main_id' and server='$server' LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$tmp = $STH->fetch();

	$STH = $pdo->query("SELECT id,trim from gifts WHERE trim>'$tmp->trim' and server='$server'");
	$STH->execute();
	$row   = $STH->fetchAll();
	$count = count($row);

	if($count == 0) {
		$pdo->exec("DELETE FROM gifts__tarifs WHERE service='$main_id'");
		$pdo->exec("DELETE FROM gifts WHERE id='$main_id' LIMIT 1");
		exit(json_encode(array('status' => '1')));
	}

	for($i = 0; $i < $count; $i++) {
		$id   = $row[$i]['id'];
		$STH  = $pdo->prepare("UPDATE gifts SET trim=:trim WHERE id='$id' and server='$server' LIMIT 1");
		$trim = $row[$i][trim] - 1;
		if($STH->execute(array('trim' => $trim)) != '1') {
			exit(json_encode(array('status' => '2')));
		}
	}

	$pdo->exec("DELETE FROM gifts__tarifs WHERE service='$main_id'");
	$pdo->exec("DELETE FROM gifts WHERE id='$main_id' LIMIT 1");
	exit(json_encode(array('status' => '1')));
}
if(isset($_POST['add_service'])) {
	$server         = checkJs($_POST['server'], "int");
	$name           = checkJs($_POST['name'], null);
	$flags          = checkJs($_POST['flags'], null);
	$stime          = checkJs($_POST['stime'], null);
	$sale           = checkJs($_POST['sale'], "int");
	$show           = check($_POST['show'], "int");
	$discount       = check($_POST['discount'], "int");

	include_once '../inc/classes/HTMLPurifier/HTMLPurifier.auto.php';
	$text = $Purifier->purify($_POST['text']);
	$text = find_img_mp3($text, rand(1, 250), 1);

	if(empty($server)) {
		exit (json_encode(array('status' => '2', 'input' => 'server', 'reply' => 'Заполните!')));
	}
	if(empty($name)) {
		exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($name, 'UTF-8') > 255) {
		exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Не более 255 символов!')));
	}
	if(mb_strlen($text, 'UTF-8') > 10000) {
		exit (json_encode(array('status' => '2', 'input' => 'text', 'reply' => 'Слишком длинный контент.')));
	}
	if($sale != 1 and $sale != 2) {
		exit (json_encode(array('status' => '2', 'input' => 'sale', 'reply' => 'Неверное значение!')));
	}
	
	if($show != 1 and $show != 2) {
		exit (json_encode(array('status' => '2', 'input' => 'show', 'reply' => 'Неверное значение!')));
	}
	if(empty($discount)) {
		$discount = 0;
	} else {
		if($discount > 99) {
			exit (json_encode(array('status' => '2', 'input' => 'discount', 'reply' => 'Не более 99')));
		}
	}
	
	if(empty($flags)) {
		exit (json_encode(array('status' => '2', 'input' => 'flags', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($flags, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'flags', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($stime)) {
		exit (json_encode(array('status' => '2', 'input' => 'stime', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($stime, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'stime', 'reply' => 'Не более 25 символов!')));
	}
	
	$dbhost = checkJs($_POST['db_ihost'], null);
	$dbuser = checkJs($_POST['db_ilogin'], null);
	$dbpass = checkJs($_POST['db_ipass'], null);
	$dbname = checkJs($_POST['db_iname'], null);
	
	if(empty($dbhost) || empty($dbuser) || empty($dbpass) || empty($dbname)) {
		$STH = $pdo->query("SELECT * FROM servers WHERE id='$server' LIMIT 1");
		$STH->setFetchMode(PDO::FETCH_OBJ);
		$srv = $STH->fetch();
		if(empty($srv->id)) {
			exit (json_encode(array('status' => '3', 'data' => 'Данного сервера не существует')));
		}
		
		$dbhost = $srv->db_host;
		$dbuser = $srv->db_user;
		$dbpass = $srv->db_pass;
		$dbname = $srv->db_db;
	}
	
	$STH = $pdo->query("SELECT trim from gifts WHERE server='$server' ORDER BY trim DESC LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$tmp = $STH->fetch();
	if(isset($tmp->trim)) {
		$trim = $tmp->trim + 1;
	} else {
		$trim = 1;
	}
	
	$STH = $pdo->prepare("INSERT INTO gifts (discount,name,rights,server,text,trim,sale,show_adm,stime,dbhost,dbuser,dbpass,dbname) VALUES (:discount, :name, :rights, :server, :text, :trim, :sale, :show_adm, :stime, :dbhost, :dbuser, :dbpass, :dbname)");
	if($STH->execute(array('discount'    => $discount,
						   'name'        => $name,
						   'rights'      => $flags,
						   'stime'      => $stime,
						   'server'      => $server,
						   'text'        => $text,
						   'trim'        => $trim,
						   'sale'        => $sale,
						   'dbhost'        => $dbhost,
						   'dbuser'        => $dbuser,
						   'dbpass'        => $dbpass,
						   'dbname'        => $dbname,
						   'show_adm'    => $show)) == '1') {
		exit(json_encode(array('status' => '1', 'id' => $server)));
	}
	
	exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Услуга с данной группой уже создана')));
}
if(isset($_POST['edit_service'])) {
	$id             = checkJs($_POST['id'], "int");
	$sale           = checkJs($_POST['sale'], "int");
	$name           = checkJs($_POST['name'], null);
	$flags          = checkJs($_POST['flags'], null);
	$stime          = checkJs($_POST['stime'], null);
	$sale           = checkJs($_POST['sale'], "int");
	$show           = check($_POST['show'], "int");
	$discount       = check($_POST['discount'], "int");
	$dbhost			= checkJs($_POST['db_ihost'], null);
	$dbuser			= checkJs($_POST['db_ilogin'], null);
	$dbpass			= checkJs($_POST['db_ipass'], null);
	$dbname			= checkJs($_POST['db_iname'], null);
	
	include_once '../inc/classes/HTMLPurifier/HTMLPurifier.auto.php';
	$text = $Purifier->purify($_POST['text']);
	$text = find_img_mp3($text, rand(1, 250), 1);

	if(empty($id)) {
		exit(json_encode(array('status' => '2')));
	}
	if(empty($name)) {
		exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($name, 'UTF-8') > 255) {
		exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Не более 255 символов!')));
	}
	if(mb_strlen($text, 'UTF-8') > 10000) {
		exit (json_encode(array('status' => '2', 'input' => 'text', 'reply' => 'Слишком длинный контент.')));
	}
	if($sale != 1 and $sale != 2) {
		exit (json_encode(array('status' => '2', 'input' => 'sale', 'reply' => 'Неверное значение!')));
	}
	if($show != 1 and $show != 2) {
		exit (json_encode(array('status' => '2', 'input' => 'show', 'reply' => 'Неверное значение!')));
	}
	if(empty($discount)) {
		$discount = 0;
	} else {
		if($discount > 99) {
			exit (json_encode(array('status' => '2', 'input' => 'discount', 'reply' => 'Не более 99')));
		}
	}

	$STH = $pdo->prepare("SELECT `server` FROM `gifts` WHERE `id`=:id LIMIT 1");
	$STH->setFetchMode(PDO::FETCH_OBJ);
	$STH->execute(array(':id' => $id));
	$row = $STH->fetch();
	if(empty($row->server)) {
		exit (json_encode(array('status' => '2', 'input' => 'name', 'reply' => 'Услуга с данным id не найдена')));
	}

	if(empty($flags)) {
		exit (json_encode(array('status' => '2', 'input' => 'flags', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($flags, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'flags', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($stime)) {
		exit (json_encode(array('status' => '2', 'input' => 'stime', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($stime, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'stime', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($dbhost)) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ihost', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($dbhost, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ihost', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($dbuser)) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ilogin', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($dbuser, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ilogin', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($dbpass)) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ipass', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($dbpass, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'db_ipass', 'reply' => 'Не более 25 символов!')));
	}
	
	if(empty($dbname)) {
		exit (json_encode(array('status' => '2', 'input' => 'db_iname', 'reply' => 'Заполните!')));
	}
	if(mb_strlen($dbname, 'UTF-8') > 25) {
		exit (json_encode(array('status' => '2', 'input' => 'db_iname', 'reply' => 'Не более 25 символов!')));
	}
	
	
	$STH = $pdo->prepare("UPDATE gifts SET dbhost=:dbhost,dbuser=:dbuser,dbpass=:dbpass,dbname=:dbname,stime=:stime,discount=:discount,name=:name,rights=:rights,text=:text,sale=:sale,show_adm=:show_adm WHERE id='$id' LIMIT 1");
	if($STH->execute(array('discount'    => $discount,
						   'name'        => $name,
						   'rights'      => $flags,
						   'stime'       => $stime,
						   'text'        => $text,
						   'sale'        => $sale,
						   'dbhost'        => $dbhost,
						   'dbuser'        => $dbuser,
						   'dbpass'        => $dbpass,
						   'dbname'        => $dbname,
						   'show_adm'    => $show)) == '1') {
		exit(json_encode(array('status' => '1')));
	}
}
